/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import java.util.HashMap;

public class DybroFrenchHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = 8798606577201646967L;

    public DybroFrenchHeadFinder() {
        this(new FrenchTreebankLanguagePack());
    }

    public DybroFrenchHeadFinder(TreebankLanguagePack tlp) {
        super(tlp);
        this.nonTerminalInfo = new HashMap();
        this.nonTerminalInfo.put(tlp.startSymbol(), new String[][]{{"right", "VN", "AP", "NP", "Srel", "VPpart", "AdP", "I", "Ssub", "VPinf", "PP", "ADV"}, {"right"}});
        this.nonTerminalInfo.put("SENT", new String[][]{{"right", "VN", "AP", "NP", "Srel", "VPpart", "AdP", "I", "Ssub", "VPinf", "PP", "ADV"}, {"right"}});
        this.nonTerminalInfo.put("AP", new String[][]{{"right", "A", "ET", "V", "ADV"}});
        this.nonTerminalInfo.put("AdP", new String[][]{{"right", "ADV"}, {"right"}});
        this.nonTerminalInfo.put("COORD", new String[][]{{"leftdis", "C", "CC", "CS"}, {"left"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"leftdis", "N", "PRO"}, {"left", "NP", "A", "AP", "I", "VPpart", "ADV", "AdP", "ET", "D"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"left", "P"}, {"left"}});
        this.nonTerminalInfo.put("VN", new String[][]{{"right", "V", "VPinf"}, {"right"}});
        this.nonTerminalInfo.put("VPinf", new String[][]{{"left", "VN", "V"}, {"left"}});
        this.nonTerminalInfo.put("VPpart", new String[][]{{"left", "V", "VN"}, {"left"}});
        this.nonTerminalInfo.put("Srel", new String[][]{{"right", "VN", "AP", "NP"}, {"right"}});
        this.nonTerminalInfo.put("Ssub", new String[][]{{"right", "VN", "AP", "NP", "PP", "VPinf", "Ssub", "VPpart", "A", "ADV"}, {"right"}});
        this.nonTerminalInfo.put("Sint", new String[][]{{"right", "VN", "AP", "NP", "PP", "VPinf", "Ssub", "VPpart", "A", "ADV"}, {"right"}});
        this.nonTerminalInfo.put("MWD", new String[][]{{"left", "D"}, {"left"}});
        this.nonTerminalInfo.put("MWA", new String[][]{{"left", "P"}, {"left", "N"}, {"right", "A"}, {"right"}});
        this.nonTerminalInfo.put("MWC", new String[][]{{"left", "C", "CS"}, {"left"}});
        this.nonTerminalInfo.put("MWN", new String[][]{{"right", "N", "ET"}, {"right"}});
        this.nonTerminalInfo.put("MWV", new String[][]{{"left", "V"}, {"left"}});
        this.nonTerminalInfo.put("MWP", new String[][]{{"left", "P", "ADV", "PRO"}, {"left"}});
        this.nonTerminalInfo.put("MWPRO", new String[][]{{"left", "PRO", "CL", "N", "A"}, {"left"}});
        this.nonTerminalInfo.put("MWCL", new String[][]{{"left", "CL"}, {"right"}});
        this.nonTerminalInfo.put("MWADV", new String[][]{{"left", "P", "ADV"}, {"left"}});
        this.nonTerminalInfo.put("MWI", new String[][]{{"left", "N", "ADV", "P"}, {"left"}});
        this.nonTerminalInfo.put("MWET", new String[][]{{"left", "ET", "N"}, {"left"}});
        this.nonTerminalInfo.put("DUMMYP", new String[][]{{"left"}});
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        final DybroFrenchHeadFinder chf = new DybroFrenchHeadFinder();
        ((Treebank)treebank).apply(new TreeVisitor(){

            public void visitTree(Tree pt) {
                pt.percolateHeads(chf);
                pt.pennPrint();
                System.out.println();
            }
        });
    }
}

