import mimetypes
import os

from fastapi import FastAPI
from starlette.exceptions import HTTPException
from starlette.staticfiles import StaticFiles

from . import report, threading_analysis, hotspot_analysis, system_router
from ..config import get_config


def register_routers(app: FastAPI):
    config = get_config()
    app.include_router(report.router, prefix="/api")
    app.include_router(threading_analysis.router, prefix="/api")
    app.include_router(hotspot_analysis.router, prefix="/api")
    app.include_router(system_router.router, prefix="/api")

    mimetypes.add_type('application/javascript', '.js')
    mimetypes.add_type('text/css', '.css')
    mimetypes.add_type('text/html', '.html')
    os.makedirs(config.static_path, exist_ok=True)
    app.mount("/", SPAStaticFiles(directory=config.static_path, html=True), name="app")


class SPAStaticFiles(StaticFiles):
    async def get_response(self, path: str, scope):
        try:
            return await super().get_response(path, scope)
        except HTTPException as ex:
            if ex.status_code == 404:
                return await super().get_response("index.html", scope)
            raise ex
