/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.OptionalParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalParameters {
    private static final Logger logger = LoggerFactory.getLogger(OptionalParameters.class);

    private OptionalParameters() {
        throw new InstantiationError("This class must not be instantiated");
    }

    public static OptionalParameter.Short newSarMsgRefNum(short value) {
        return new OptionalParameter.Short(OptionalParameter.Tag.SAR_MSG_REF_NUM, value);
    }

    public static OptionalParameter.Short newSarMsgRefNum(int value) {
        return OptionalParameters.newSarMsgRefNum((byte)value);
    }

    public static OptionalParameter.Byte newSarSegmentSeqnum(byte value) {
        return new OptionalParameter.Byte(OptionalParameter.Tag.SAR_SEGMENT_SEQNUM, value);
    }

    public static OptionalParameter.Byte newSarSegmentSeqnum(int value) {
        return OptionalParameters.newSarSegmentSeqnum((byte)value);
    }

    public static OptionalParameter.Byte newSarTotalSegments(byte value) {
        return new OptionalParameter.Byte(OptionalParameter.Tag.SAR_TOTAL_SEGMENTS, value);
    }

    public static OptionalParameter.Byte newSarTotalSegments(int value) {
        return OptionalParameters.newSarTotalSegments((byte)value);
    }

    public static OptionalParameter deserialize(short tagCode, byte[] content) {
        OptionalParameter.Tag tag = OptionalParameter.Tag.valueOf(tagCode);
        if (tag == null) {
            logger.debug("Optional Parameter Tag not recognized for deserialization: {}", (Object)tagCode);
            return new OptionalParameter.OctetString(tagCode, content);
        }
        switch (tag) {
            case DEST_ADDR_SUBUNIT: {
                return new OptionalParameter.Dest_addr_subunit(content);
            }
            case DEST_NETWORK_TYPE: {
                return new OptionalParameter.Dest_network_type(content);
            }
            case DEST_BEARER_TYPE: {
                return new OptionalParameter.Dest_bearer_type(content);
            }
            case DEST_TELEMATICS_ID: {
                return new OptionalParameter.Dest_telematics_id(content);
            }
            case SOURCE_ADDR_SUBUNIT: {
                return new OptionalParameter.Source_addr_subunit(content);
            }
            case SOURCE_NETWORK_TYPE: {
                return new OptionalParameter.Source_network_type(content);
            }
            case SOURCE_BEARER_TYPE: {
                return new OptionalParameter.Source_bearer_type(content);
            }
            case SOURCE_TELEMATICS_ID: {
                return new OptionalParameter.Source_telematics_id(content);
            }
            case QOS_TIME_TO_LIVE: {
                return new OptionalParameter.Qos_time_to_live(content);
            }
            case PAYLOAD_TYPE: {
                return new OptionalParameter.Payload_type(content);
            }
            case ADDITIONAL_STATUS_INFO_TEXT: {
                return new OptionalParameter.Additional_status_info_text(content);
            }
            case RECEIPTED_MESSAGE_ID: {
                return new OptionalParameter.Receipted_message_id(content);
            }
            case MS_MSG_WAIT_FACILITIES: {
                return new OptionalParameter.Ms_msg_wait_facilities(content);
            }
            case PRIVACY_INDICATOR: {
                return new OptionalParameter.Privacy_indicator(content);
            }
            case SOURCE_SUBADDRESS: {
                return new OptionalParameter.Source_subaddress(content);
            }
            case DEST_SUBADDRESS: {
                return new OptionalParameter.Dest_subaddress(content);
            }
            case USER_MESSAGE_REFERENCE: {
                return new OptionalParameter.User_message_reference(content);
            }
            case USER_RESPONSE_CODE: {
                return new OptionalParameter.User_response_code(content);
            }
            case SOURCE_PORT: {
                return new OptionalParameter.Source_port(content);
            }
            case DESTINATION_PORT: {
                return new OptionalParameter.Destination_port(content);
            }
            case SAR_MSG_REF_NUM: {
                return new OptionalParameter.Sar_msg_ref_num(content);
            }
            case LANGUAGE_INDICATOR: {
                return new OptionalParameter.Language_indicator(content);
            }
            case SAR_TOTAL_SEGMENTS: {
                return new OptionalParameter.Sar_total_segments(content);
            }
            case SAR_SEGMENT_SEQNUM: {
                return new OptionalParameter.Sar_segment_seqnum(content);
            }
            case SC_INTERFACE_VERSION: {
                return new OptionalParameter.Sc_interface_version(content);
            }
            case CALLBACK_NUM_PRES_IND: {
                return new OptionalParameter.Callback_num_pres_ind(content);
            }
            case CALLBACK_NUM_ATAG: {
                return new OptionalParameter.Callback_num_atag(content);
            }
            case NUMBER_OF_MESSAGES: {
                return new OptionalParameter.Number_of_messages(content);
            }
            case CALLBACK_NUM: {
                return new OptionalParameter.Callback_num(content);
            }
            case DPF_RESULT: {
                return new OptionalParameter.Dpf_result(content);
            }
            case SET_DPF: {
                return new OptionalParameter.Set_dpf(content);
            }
            case MS_AVAILABILITY_STATUS: {
                return new OptionalParameter.Ms_availability_status(content);
            }
            case NETWORK_ERROR_CODE: {
                return new OptionalParameter.Network_error_code(content);
            }
            case MESSAGE_PAYLOAD: {
                return new OptionalParameter.Message_payload(content);
            }
            case DELIVERY_FAILURE_REASON: {
                return new OptionalParameter.Delivery_failure_reason(content);
            }
            case MORE_MESSAGES_TO_SEND: {
                return new OptionalParameter.More_messages_to_send(content);
            }
            case MESSAGE_STATE: {
                return new OptionalParameter.Message_state(content);
            }
            case USSD_SERVICE_OP: {
                return new OptionalParameter.Ussd_service_op(content);
            }
            case BILLING_IDENTIFICATION: {
                return new OptionalParameter.Billing_identification(content);
            }
            case DISPLAY_TIME: {
                return new OptionalParameter.Display_time(content);
            }
            case SMS_SIGNAL: {
                return new OptionalParameter.Sms_signal(content);
            }
            case MS_VALIDITY: {
                return new OptionalParameter.Ms_validity(content);
            }
            case ALERT_ON_MESSAGE_DELIVERY: {
                return new OptionalParameter.Alert_on_message_delivery(content);
            }
            case ITS_REPLY_TYPE: {
                return new OptionalParameter.Its_reply_type(content);
            }
            case ITS_SESSION_INFO: {
                return new OptionalParameter.Its_session_info(content);
            }
            case VENDOR_SPECIFIC_SOURCE_MSC_ADDR: {
                return new OptionalParameter.Vendor_specific_source_msc_addr(content);
            }
            case VENDOR_SPECIFIC_DEST_MSC_ADDR: {
                return new OptionalParameter.Vendor_specific_dest_msc_addr(content);
            }
        }
        logger.warn("Missing code in deserialize to handle Optional Parameter Tag: {}", (Object)tag);
        logger.warn("Falling back to basic OptionalParameter types for {}", (Object)tag);
        if (OptionalParameter.Null.class.isAssignableFrom(tag.type)) {
            return new OptionalParameter.Null(tagCode);
        }
        if (OptionalParameter.Byte.class.isAssignableFrom(tag.type)) {
            return new OptionalParameter.Byte(tagCode, content);
        }
        if (OptionalParameter.Short.class.isAssignableFrom(tag.type)) {
            return new OptionalParameter.Short(tagCode, content);
        }
        if (OptionalParameter.Int.class.isAssignableFrom(tag.type)) {
            return new OptionalParameter.Int(tagCode, content);
        }
        if (OptionalParameter.OctetString.class.isAssignableFrom(tag.type)) {
            return new OptionalParameter.OctetString(tagCode, content);
        }
        if (OptionalParameter.COctetString.class.isAssignableFrom(tag.type)) {
            return new OptionalParameter.COctetString(tagCode, content);
        }
        throw new IllegalArgumentException("Unsupported tag: " + tagCode);
    }

    public static <U extends OptionalParameter> U get(Class<U> tagClass, OptionalParameter[] parameters) {
        if (parameters != null) {
            for (OptionalParameter i : parameters) {
                if (i.getClass() != tagClass) continue;
                return (U)i;
            }
        }
        logger.info("Optional Parameter Tag {} not found", tagClass);
        return null;
    }

    public static OptionalParameter get(short tag, OptionalParameter[] parameters) {
        if (parameters != null) {
            for (OptionalParameter i : parameters) {
                if (i.tag != tag) continue;
                return i;
            }
        }
        logger.info("Optional Parameter Tag {} not found", (Object)tag);
        return null;
    }
}

