/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.metadata;

import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.metadata.DataBean;
import com.ibm.db2.cmx.internal.metadata.DataBeanBaseStatistic;
import com.ibm.db2.cmx.internal.metadata.DataBeanStatementExecution;
import java.util.ArrayList;
import java.util.List;

public class DataBeanTransactionExecution
extends DataBeanBaseStatistic {
    public static final int CLIENT_USER = 0;
    public static final int CLIENT_WORKSTATION = 1;
    public static final int CLIENT_APPLICATION = 2;
    public static final int CLIENT_ACCOUNTING = 3;
    public String[] clientInfoFields = new String[4];
    public String[] endUOWclientInfoFields_;
    public String[] endUOWSettings_;
    private String cachedClientInfoString_ = null;
    public String cachedEndUOWClientInfoString_ = null;
    public String cachedEndUOWSettingsString_ = null;
    public String connectionCorrelator_ = null;
    public List<DataBeanStatementExecution> statementExecutions_ = new ArrayList<DataBeanStatementExecution>();
    public Object[] wasGetConnectionData_;
    public int aggregatedWasMaxPoolWaitTimeType_;
    public long aggregatedWasMaxPoolWaitTime_ = -1L;
    public long transactionStart_;
    private long transactionElapsedTime_;
    private boolean isCompleted_ = false;
    private JSONObject aggregatedUOWSEQ_ = null;
    private int aggregatedStatementExecutionsCount_ = 0;
    public long aggregatedMaxTransactionElapsedTime_ = 0L;
    public long aggregatedMaxInflightTransactionElapsedTime_ = 0L;
    private int[] aggregatedHistogram_ = null;
    private static int[] histogramDefinition = new int[]{1, 2, 3, 4, 5, 7, 10, 15, 20, 30, 40, 50, 70, 100, 150, 200, 300, 400, 500, 700, 1000, 1500, 2000, 3000, 4000, 5000, 7000, 10000, 15000, 20000, 30000, 45000, 60000, 90000, 120000, 180000, 240000, 300000, 420000, 600000, 900000, 1200000, 1800000, 2700000, 3600000, 5400000, 0x6DDD00, 10800000, 14400000, 18000000, 25200000, 36000000};

    public void addStatementExecution(DataBeanStatementExecution dataBeanStatementExecution) {
        this.accumulate(dataBeanStatementExecution);
        this.statementExecutions_.add(dataBeanStatementExecution);
        if (this.uowSeq_ == 0L && dataBeanStatementExecution.uowSeq_ > 0L) {
            this.uowSeq_ = dataBeanStatementExecution.uowSeq_;
        }
    }

    public boolean transactionStarted() {
        return this.transactionStart_ > 0L;
    }

    public void beginTransaction() {
        this.transactionStart_ = System.currentTimeMillis();
    }

    public void completeTransaction(boolean bl2) {
        if (this.transactionStarted()) {
            this.isCompleted_ = bl2;
            long l2 = System.currentTimeMillis();
            this.transactionElapsedTime_ = l2 - this.transactionStart_;
        }
    }

    public DataBeanTransactionExecution cloneForInflight() {
        DataBeanTransactionExecution dataBeanTransactionExecution = new DataBeanTransactionExecution();
        dataBeanTransactionExecution.authid_ = this.authid_;
        dataBeanTransactionExecution.clientInfoFields = this.clientInfoFields;
        dataBeanTransactionExecution.transactionStart_ = this.transactionStart_;
        dataBeanTransactionExecution.completeTransaction(false);
        return dataBeanTransactionExecution;
    }

    @Override
    public void prepareForAggregation() {
        super.prepareForAggregation();
        if (this.isCompleted_) {
            this.aggregatedMaxTransactionElapsedTime_ = this.transactionElapsedTime_;
            this.aggregatedStatementExecutionsCount_ = this.statementExecutions_.size();
            if (this.wasGetConnectionData_ != null && this.wasGetConnectionData_.length >= 3) {
                this.aggregatedWasMaxPoolWaitTime_ = (Long)this.wasGetConnectionData_[2];
                this.aggregatedWasMaxPoolWaitTimeType_ = (Integer)this.wasGetConnectionData_[1];
            }
            this.incrementHistogram(this.transactionElapsedTime_);
            if (this.uowSeq_ > 0L && this.connectionCorrelator_ != null) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.add((Object)this.uowSeq_);
                this.aggregatedUOWSEQ_ = new JSONObject();
                this.aggregatedUOWSEQ_.put(this.connectionCorrelator_, jSONArray);
            }
        } else {
            this.aggregatedMaxInflightTransactionElapsedTime_ = this.transactionElapsedTime_;
            this.aggregatedNumExecutions_ = 0;
            this.transactionElapsedTime_ = 0L;
        }
    }

    public void aggregateInflight(DataBeanTransactionExecution dataBeanTransactionExecution) {
        if (dataBeanTransactionExecution.transactionElapsedTime_ > this.aggregatedMaxInflightTransactionElapsedTime_) {
            this.aggregatedMaxInflightTransactionElapsedTime_ = dataBeanTransactionExecution.transactionElapsedTime_;
        }
    }

    public void aggregate(DataBeanTransactionExecution dataBeanTransactionExecution) {
        super.aggregate(dataBeanTransactionExecution);
        this.transactionElapsedTime_ += dataBeanTransactionExecution.transactionElapsedTime_;
        if (dataBeanTransactionExecution.transactionElapsedTime_ > this.aggregatedMaxTransactionElapsedTime_) {
            this.aggregatedMaxTransactionElapsedTime_ = dataBeanTransactionExecution.transactionElapsedTime_;
        }
        if (dataBeanTransactionExecution.aggregatedWasMaxPoolWaitTime_ > this.aggregatedWasMaxPoolWaitTime_) {
            this.aggregatedWasMaxPoolWaitTime_ = dataBeanTransactionExecution.aggregatedWasMaxPoolWaitTime_;
            this.aggregatedWasMaxPoolWaitTimeType_ = dataBeanTransactionExecution.aggregatedWasMaxPoolWaitTimeType_;
        }
        this.aggregatedStatementExecutionsCount_ += dataBeanTransactionExecution.statementExecutions_.size();
        this.incrementHistogram(dataBeanTransactionExecution.transactionElapsedTime_);
        if (dataBeanTransactionExecution.wasGetConnectionData_ != null) {
            if (this.wasGetConnectionData_ == null) {
                this.wasGetConnectionData_ = dataBeanTransactionExecution.wasGetConnectionData_;
            } else {
                this.wasGetConnectionData_[2] = (Long)dataBeanTransactionExecution.wasGetConnectionData_[2] + (Long)this.wasGetConnectionData_[2];
            }
        }
        if (this.aggregatedUOWSEQ_ != null) {
            JSONArray jSONArray = (JSONArray)this.aggregatedUOWSEQ_.get(dataBeanTransactionExecution.connectionCorrelator_);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
                this.aggregatedUOWSEQ_.put(dataBeanTransactionExecution.connectionCorrelator_, jSONArray);
            }
            jSONArray.add((Object)dataBeanTransactionExecution.uowSeq_);
        }
    }

    private void incrementHistogram(long l2) {
        if (this.aggregatedHistogram_ == null) {
            this.aggregatedHistogram_ = new int[53];
        }
        for (int i10 = 0; i10 < histogramDefinition.length; ++i10) {
            if (l2 >= (long)histogramDefinition[i10]) continue;
            int n2 = i10;
            this.aggregatedHistogram_[n2] = this.aggregatedHistogram_[n2] + 1;
            return;
        }
        this.aggregatedHistogram_[52] = this.aggregatedHistogram_[52] + 1;
    }

    private String getHistogramString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        boolean bl2 = true;
        if (this.aggregatedHistogram_ != null) {
            for (int i10 = 0; i10 < this.aggregatedHistogram_.length; ++i10) {
                if (this.aggregatedHistogram_[i10] <= 0) continue;
                if (!bl2) {
                    stringBuilder.append(',');
                }
                bl2 = false;
                stringBuilder.append(Integer.toString(i10 + 1));
                stringBuilder.append('=');
                stringBuilder.append(Integer.toString(this.aggregatedHistogram_[i10]));
            }
        }
        return stringBuilder.toString();
    }

    public JSONArray toJSON_DSM() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(this.authid_);
        jSONArray.add((Object)this.aggregatedClientInfoCacheIndex_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.applicationElapsedTimeForQueriesIncludingDriverTime_);
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 0));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 1));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 2));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 3));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 4));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 5));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 6));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 7));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 8));
        jSONArray.add((Object)this.numRowsReturned_);
        jSONArray.add((Object)this.aggregatedStatementExecutionsCount_);
        jSONArray.add((Object)this.firstNegativeSqlCode_);
        jSONArray.add((Object)this.aggregatedNumNegativeSqlCodes_);
        jSONArray.add((Object)this.aggregatedNumExecutions_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.transactionElapsedTime_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.aggregatedMaxTransactionElapsedTime_);
        jSONArray.add(this.getHistogramString());
        jSONArray.add(DataBean.get(this.wasGetConnectionData_, 1));
        jSONArray.add(DataBean.get(this.wasGetConnectionData_, 2));
        return jSONArray;
    }

    public JSONArray toJSONv1() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(this.authid_);
        jSONArray.add((Object)this.aggregatedClientInfoCacheIndex_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.applicationElapsedTimeForQueriesIncludingDriverTime_);
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 0));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 1));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 2));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 3));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 4));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 5));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 6));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 7));
        jSONArray.add((Object)DataBean.get(this.driverTimings_, 8));
        jSONArray.add((Object)this.numRowsReturned_);
        jSONArray.add((Object)this.aggregatedStatementExecutionsCount_);
        jSONArray.add((Object)this.firstNegativeSqlCode_);
        jSONArray.add((Object)this.aggregatedNumNegativeSqlCodes_);
        jSONArray.add((Object)this.aggregatedNumExecutions_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.transactionElapsedTime_);
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.aggregatedMaxTransactionElapsedTime_);
        jSONArray.add(this.getHistogramString());
        jSONArray.add(DataBean.get(this.wasGetConnectionData_, 1));
        jSONArray.add(DataBean.get(this.wasGetConnectionData_, 2));
        return jSONArray;
    }

    public JSONArray toJSONv2() {
        JSONArray jSONArray = this.toJSONv1();
        jSONArray.add(this.aggregatedUOWSEQ_ == null ? null : this.aggregatedUOWSEQ_.toString());
        jSONArray.add((Object)1);
        jSONArray.add((Object)this.aggregatedMaxInflightTransactionElapsedTime_);
        return jSONArray;
    }

    public JSONArray toJSONv3() {
        JSONArray jSONArray = this.toJSONv2();
        jSONArray.add((Object)this.aggregatedEUOWClientInfoCacheIndex_);
        jSONArray.add((Object)this.aggregatedEUOWSettingsCacheIndex_);
        return jSONArray;
    }

    public JSONArray toJSONv4() {
        JSONArray jSONArray = this.toJSONv3();
        return jSONArray;
    }

    public JSONArray toJSONv5() {
        JSONArray jSONArray = this.toJSONv4();
        jSONArray.add(new JSONArray());
        return jSONArray;
    }

    public JSONArray toJSON(int n2) {
        switch (n2) {
            case 1: {
                return this.toJSONv1();
            }
            case 2: {
                return this.toJSONv2();
            }
            case 3: {
                return this.toJSONv3();
            }
            case 4: {
                return this.toJSONv4();
            }
            case 5: {
                return this.toJSONv5();
            }
        }
        return this.toJSONv5();
    }

    public String getKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.authid_);
        stringBuilder.append(',');
        stringBuilder.append(this.getClientInfoString());
        stringBuilder.append(',');
        stringBuilder.append(this.getEUOWClientInfoString());
        stringBuilder.append(',');
        stringBuilder.append(this.getEUOWSettingsString());
        return stringBuilder.toString();
    }

    public String getClientInfoString() {
        if (this.cachedClientInfoString_ != null) {
            return this.cachedClientInfoString_;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.clientInfoFields[0]);
        stringBuilder.append(',');
        stringBuilder.append(this.clientInfoFields[1]);
        stringBuilder.append(',');
        stringBuilder.append(this.clientInfoFields[2]);
        stringBuilder.append(',');
        stringBuilder.append(this.clientInfoFields[3]);
        this.cachedClientInfoString_ = stringBuilder.toString();
        return this.cachedClientInfoString_;
    }

    private final boolean isEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null && object2 == null) {
            return false;
        }
        if (object2 != null && object == null) {
            return false;
        }
        return object.equals(object2);
    }

    public String getEUOWClientInfoString() {
        if (this.cachedEndUOWClientInfoString_ != null) {
            return this.cachedEndUOWClientInfoString_;
        }
        if (this.endUOWclientInfoFields_ == null) {
            this.cachedEndUOWClientInfoString_ = "";
        } else if (this.isEqual(this.clientInfoFields[0], this.endUOWclientInfoFields_[0]) && this.isEqual(this.clientInfoFields[1], this.endUOWclientInfoFields_[1]) && this.isEqual(this.clientInfoFields[2], this.endUOWclientInfoFields_[2]) && this.isEqual(this.clientInfoFields[3], this.endUOWclientInfoFields_[3])) {
            this.cachedEndUOWClientInfoString_ = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.endUOWclientInfoFields_[0]);
            stringBuilder.append(',');
            stringBuilder.append(this.endUOWclientInfoFields_[1]);
            stringBuilder.append(',');
            stringBuilder.append(this.endUOWclientInfoFields_[2]);
            stringBuilder.append(',');
            stringBuilder.append(this.endUOWclientInfoFields_[3]);
            this.cachedEndUOWClientInfoString_ = stringBuilder.toString();
        }
        return this.cachedEndUOWClientInfoString_;
    }

    public String getEUOWSettingsString() {
        if (this.cachedEndUOWSettingsString_ != null) {
            return this.cachedEndUOWSettingsString_;
        }
        if (this.endUOWSettings_ == null || this.endUOWSettings_[0] == null && this.endUOWSettings_[1] == null && this.endUOWSettings_[2] == null) {
            this.cachedEndUOWSettingsString_ = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.endUOWSettings_[0]);
            stringBuilder.append(',');
            stringBuilder.append(this.endUOWSettings_[1]);
            stringBuilder.append(',');
            stringBuilder.append(this.endUOWSettings_[2]);
            this.cachedEndUOWSettingsString_ = stringBuilder.toString();
        }
        return this.cachedEndUOWSettingsString_;
    }

    public void setDb2PackagePath(String string) {
        for (int i10 = 0; i10 < this.statementExecutions_.size(); ++i10) {
            this.statementExecutions_.get((int)i10).db2PackagePath_ = string;
        }
    }
}

