/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import net.jpountz.util.SafeUtils;
import net.jpountz.util.UnsafeUtils;
import net.jpountz.xxhash.AbstractStreamingXXHash32Java;
import net.jpountz.xxhash.StreamingXXHash32;

final class StreamingXXHash32JavaUnsafe
extends AbstractStreamingXXHash32Java {
    StreamingXXHash32JavaUnsafe(int n2) {
        super(n2);
    }

    @Override
    public int getValue() {
        int n2;
        int n3 = this.totalLen >= 16L ? Integer.rotateLeft(this.v1, 1) + Integer.rotateLeft(this.v2, 7) + Integer.rotateLeft(this.v3, 12) + Integer.rotateLeft(this.v4, 18) : this.seed + 374761393;
        n3 = (int)((long)n3 + this.totalLen);
        for (n2 = 0; n2 <= this.memSize - 4; n2 += 4) {
            n3 += UnsafeUtils.readIntLE(this.memory, n2) * -1028477379;
            n3 = Integer.rotateLeft(n3, 17) * 668265263;
        }
        while (n2 < this.memSize) {
            n3 += (UnsafeUtils.readByte(this.memory, n2) & 0xFF) * 374761393;
            n3 = Integer.rotateLeft(n3, 11) * -1640531535;
            ++n2;
        }
        n3 ^= n3 >>> 15;
        n3 *= -2048144777;
        n3 ^= n3 >>> 13;
        n3 *= -1028477379;
        n3 ^= n3 >>> 16;
        return n3;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        SafeUtils.checkRange(byArray, n2, n3);
        this.totalLen += (long)n3;
        if (this.memSize + n3 < 16) {
            System.arraycopy(byArray, n2, this.memory, this.memSize, n3);
            this.memSize += n3;
            return;
        }
        int n4 = n2 + n3;
        if (this.memSize > 0) {
            System.arraycopy(byArray, n2, this.memory, this.memSize, 16 - this.memSize);
            this.v1 += UnsafeUtils.readIntLE(this.memory, 0) * -2048144777;
            this.v1 = Integer.rotateLeft(this.v1, 13);
            this.v1 *= -1640531535;
            this.v2 += UnsafeUtils.readIntLE(this.memory, 4) * -2048144777;
            this.v2 = Integer.rotateLeft(this.v2, 13);
            this.v2 *= -1640531535;
            this.v3 += UnsafeUtils.readIntLE(this.memory, 8) * -2048144777;
            this.v3 = Integer.rotateLeft(this.v3, 13);
            this.v3 *= -1640531535;
            this.v4 += UnsafeUtils.readIntLE(this.memory, 12) * -2048144777;
            this.v4 = Integer.rotateLeft(this.v4, 13);
            this.v4 *= -1640531535;
            n2 += 16 - this.memSize;
            this.memSize = 0;
        }
        int n5 = n4 - 16;
        int n6 = this.v1;
        int n7 = this.v2;
        int n8 = this.v3;
        int n9 = this.v4;
        while (n2 <= n5) {
            n6 += UnsafeUtils.readIntLE(byArray, n2) * -2048144777;
            n6 = Integer.rotateLeft(n6, 13);
            n6 *= -1640531535;
            n7 += UnsafeUtils.readIntLE(byArray, n2 += 4) * -2048144777;
            n7 = Integer.rotateLeft(n7, 13);
            n7 *= -1640531535;
            n8 += UnsafeUtils.readIntLE(byArray, n2 += 4) * -2048144777;
            n8 = Integer.rotateLeft(n8, 13);
            n8 *= -1640531535;
            n9 += UnsafeUtils.readIntLE(byArray, n2 += 4) * -2048144777;
            n9 = Integer.rotateLeft(n9, 13);
            n9 *= -1640531535;
            n2 += 4;
        }
        this.v1 = n6;
        this.v2 = n7;
        this.v3 = n8;
        this.v4 = n9;
        if (n2 < n4) {
            System.arraycopy(byArray, n2, this.memory, 0, n4 - n2);
            this.memSize = n4 - n2;
        }
    }

    static class Factory
    implements StreamingXXHash32.Factory {
        public static final StreamingXXHash32.Factory INSTANCE = new Factory();

        Factory() {
        }

        @Override
        public StreamingXXHash32 newStreamingHash(int n2) {
            return new StreamingXXHash32JavaUnsafe(n2);
        }
    }
}

