/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.set.FrozenSetBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.set.FrozenSetBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFrozenSet})
public final class FrozenSetBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = FrozenSetBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FrozenSetBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        protected static long HASH_UNSET = -1L;

        @Specialization(guards={"self.getHash() != HASH_UNSET"})
        public static long getHash(VirtualFrame frame, PFrozenSet self) {
            return self.getHash();
        }

        @Specialization(guards={"self.getHash() == HASH_UNSET"})
        public static long computeHash(VirtualFrame frame, PFrozenSet self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iterKey, @Cached PyObjectHashNode hashNode) {
            HashingStorage storage = self.getDictStorage();
            long m1 = 1927868237L;
            long m2 = 69069L;
            long c1 = 907133923L;
            long c2 = 590923713L;
            long hash = 0L;
            int len = 0;
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            while (iterNext.execute(inliningTarget, storage, it)) {
                ++len;
                Object key = iterKey.execute(inliningTarget, storage, it);
                long tmp = hashNode.execute((Frame)frame, inliningTarget, key);
                hash ^= HashNode.shuffleBits(tmp);
            }
            hash ^= (long)(len + 1) * m1;
            hash ^= hash >> 11 ^ hash >> 25;
            if ((hash = hash * m2 + c1) == -1L) {
                hash = c2;
            }
            self.setHash(hash);
            return hash;
        }

        private static long shuffleBits(long value) {
            return (value ^ 0x55B4DB3L ^ value << 16) * -650169129L;
        }
    }

    @Builtin(name="union", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class UnionNode
    extends PythonBuiltinNode {
        UnionNode() {
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PBaseSet self, Object[] args, @Bind Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Bind PythonLanguage language) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorage.execute(frame, inliningTarget, args[i]), result);
            }
            return PFactory.createFrozenSet(language, result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PBaseSet self, Object[] args, @Bind Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Bind PythonLanguage language) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorage.execute(frame, inliningTarget, args[i]), result);
            }
            return PFactory.createFrozenSet(language, result);
        }
    }

    @Builtin(name="difference", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class DifferenceNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, PNone other, @Bind PythonLanguage language) {
            return PFactory.createFrozenSet(language, self.getDictStorage());
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return PFactory.createFrozenSet(language, result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return PFactory.createFrozenSet(language, result);
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, Object other, @Bind Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Bind PythonLanguage language) {
            HashingStorage result = diffNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getSetStorageNode.execute(frame, inliningTarget, other));
            return PFactory.createFrozenSet(language, result);
        }
    }

    @Builtin(name="symmetric_difference", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SymmetricDifferenceNode
    extends PythonBuiltinNode {
        @Specialization
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, Object other, @Bind Node inliningTarget, @Cached HashingCollectionNodes.GetSetStorageNode getHashingStorage, @Cached HashingStorageNodes.HashingStorageXor xorNode, @Bind PythonLanguage language) {
            HashingStorage result = xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorage.execute(frame, inliningTarget, other));
            return PFactory.createFrozenSet(language, result);
        }
    }

    @Builtin(name="intersection", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class IntersectNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, PNone other, @Bind PythonLanguage language) {
            return PFactory.createFrozenSet(language, self.getDictStorage());
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Bind PythonLanguage language) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = intersectNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return PFactory.createFrozenSet(language, result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Bind PythonLanguage language) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = intersectNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return PFactory.createFrozenSet(language, result);
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, Object other, @Bind Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Bind PythonLanguage language) {
            HashingStorage result = intersectNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getSetStorageNode.execute(frame, inliningTarget, other));
            return PFactory.createFrozenSet(language, result);
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isBuiltinFrozenSet(self)"})
        static PFrozenSet frozenSetIdentity(PFrozenSet self) {
            return self;
        }

        @Specialization(guards={"!isBuiltinFrozenSet(self)"})
        static PFrozenSet doGeneric(PFrozenSet self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached HashingStorageNodes.HashingStorageCopy copy) {
            return PFactory.createFrozenSet(language, copy.execute(inliningTarget, self.getDictStorage()));
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="frozenset", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class FrozenSetNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(arg)"})
        static PFrozenSet frozensetEmpty(Object cls, PNone arg, @Bind PythonLanguage language, @Cached @Cached.Shared TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createFrozenSet(language, cls, getInstanceShape.execute(cls), EmptyStorage.INSTANCE);
        }

        @Specialization(guards={"isBuiltinClass.profileIsAnyBuiltinClass(inliningTarget, cls)"})
        static PFrozenSet frozensetIdentity(Object cls, PFrozenSet arg, @Bind Node inliningTarget, @Cached.Shared(value="isBuiltinProfile") @Cached BuiltinClassProfiles.IsAnyBuiltinClassProfile isBuiltinClass) {
            return arg;
        }

        @Specialization(guards={"!isBuiltinClass.profileIsAnyBuiltinClass(inliningTarget, cls)"})
        static PFrozenSet subFrozensetIdentity(Object cls, PFrozenSet arg, @Bind Node inliningTarget, @Cached.Shared(value="isBuiltinProfile") @Cached BuiltinClassProfiles.IsAnyBuiltinClassProfile isBuiltinClass, @Bind PythonLanguage language, @Cached @Cached.Shared TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createFrozenSet(language, cls, getInstanceShape.execute(cls), arg.getDictStorage());
        }

        @Specialization(guards={"!isNoValue(iterable)", "!isPFrozenSet(iterable)"})
        static PFrozenSet frozensetIterable(VirtualFrame frame, Object cls, Object iterable, @Bind Node inliningTarget, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode, @Bind PythonLanguage language, @Cached @Cached.Shared TypeNodes.GetInstanceShape getInstanceShape) {
            HashingStorage storage = getHashingStorageNode.getForSets(frame, inliningTarget, iterable);
            return PFactory.createFrozenSet(language, cls, getInstanceShape.execute(cls), storage);
        }
    }
}

