/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

final class TableConstraintMatcher
extends AbstractRetriever {
    TableConstraintMatcher(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void matchTableConstraints(NamedObjectList<MutableTable> allTables) {
        Objects.requireNonNull(allTables, "No tables provided");
        for (MutableTable mutableTable : allTables) {
            if (mutableTable == null) continue;
            this.matchPrimaryKey(mutableTable);
            this.addImportedForeignKeys(mutableTable);
        }
    }

    private void addImportedForeignKeys(MutableTable table) {
        Collection<ForeignKey> importedForeignKeys = table.getImportedForeignKeys();
        for (ForeignKey foreignKey : importedForeignKeys) {
            Optional<TableConstraint> lookupTableConstraint = table.lookupTableConstraint(foreignKey.getName());
            if (lookupTableConstraint.isPresent()) {
                TableConstraint tableConstraint = lookupTableConstraint.get();
                this.copyRemarksAndAttributes(tableConstraint, foreignKey);
                table.removeTableConstraint(tableConstraint);
            }
            table.addTableConstraint(foreignKey);
        }
    }

    private void copyRemarksAndAttributes(TableConstraint tableConstraint, DatabaseObject databaseObject) {
        if (!databaseObject.hasRemarks() && tableConstraint.hasRemarks()) {
            databaseObject.setRemarks(tableConstraint.getRemarks());
        }
        for (Map.Entry<String, Object> attribute : tableConstraint.getAttributes().entrySet()) {
            databaseObject.setAttribute(attribute.getKey(), attribute.getValue());
        }
    }

    private void matchPrimaryKey(MutableTable table) {
        if (!table.hasPrimaryKey()) {
            return;
        }
        MutablePrimaryKey primaryKey = table.getPrimaryKey();
        for (TableConstraint tableConstraint : table.getTableConstraints()) {
            if (tableConstraint.getType() != TableConstraintType.primary_key || !primaryKey.getName().equals(tableConstraint.getName()) && !primaryKey.getConstrainedColumns().equals(tableConstraint.getConstrainedColumns())) continue;
            this.copyRemarksAndAttributes(tableConstraint, primaryKey);
            table.removeTableConstraint(tableConstraint);
        }
        table.addTableConstraint(primaryKey);
    }
}

