/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.SINT32;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeSINT32
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5465988397261455848L;
    boolean isBigEndian;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    protected OracleTypeSINT32(boolean isBigEndian) {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$8, null, isBigEndian);
            }
            this.isBigEndian = false;
            this.isBigEndian = isBigEndian;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$0, this, object, oracleConnection);
            }
            NUMBER nUMBER = OracleTypeNUMBER.toNUMBER(value, (OracleConnection)conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$0, this, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$0, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void beginIdx;
            void conn;
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$1, this, object, oracleConnection, l2, n2);
            }
            Datum[] datumArray = OracleTypeNUMBER.toNUMBERArray(obj, (OracleConnection)conn, (long)beginIdx, (int)count);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$1, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$1, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Datum toDatumInternal(Object object, OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$2, this, object, oracleConnection);
            }
            int intValue = 0;
            if (value == null) {
                Datum datum = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$2, this, datum);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$2, this, null);
                }
                return null;
            }
            if (value instanceof Number) {
                intValue = ((Number)value).intValue();
            } else if (value instanceof NUMBER) {
                NUMBER n2 = (NUMBER)value;
                intValue = n2.intValue();
            } else {
                NUMBER n3 = new NUMBER(value);
                intValue = n3.intValue();
            }
            SINT32 sINT32 = SINT32.valueOf(intValue, this.isBigEndian);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$2, this, sINT32);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$2, this, null);
            }
            return sINT32;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Datum[] toDatumArrayInternal(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void beginIdx;
            void count;
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$3, this, object, oracleConnection, l2, n2);
            }
            if (obj == null) {
                Datum[] datumArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$3, this, datumArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            Object[] arr = (Object[])obj;
            Datum[] datumArray = SINT32.createArray((int)count);
            void endIdx = beginIdx + (long)count;
            int i2 = 0;
            while (beginIdx < endIdx) {
                void conn;
                datumArray[i2] = this.toDatumInternal(arr[(int)beginIdx], (OracleConnection)conn);
                ++i2;
                ++beginIdx;
            }
            Datum[] datumArray2 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$3, this, datumArray2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$3, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getTypeCode() {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$4, this, new Object[0]);
            }
            int n2 = 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$4, this, n2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$4, this, null);
            }
            return 2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, byArray, n2, map);
            }
            if (bytes == null || ((void)bytes).length == 0) {
                Object var7_5 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, var7_5);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            int out = SINT32.bytesToInt((byte[])bytes, this.isBigEndian);
            Object obj = null;
            switch (type) {
                case 1: {
                    obj = new NUMBER(out);
                    break;
                }
                case 2: {
                    obj = new BigDecimal(out);
                    break;
                }
                case 3: {
                    obj = NUMBER.toBytes(out);
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            Object object = obj;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, object);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, null);
            }
            return obj;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$6, this, objectOutputStream);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x40L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$7, this, objectInputStream);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleTypeSINT32.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$8 = OracleTypeSINT32.class.getDeclaredConstructor(Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeSINT32.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeSINT32.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeSINT32.class.getDeclaredMethod("toObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeSINT32.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeSINT32.class.getDeclaredMethod("toDatumArrayInternal", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeSINT32.class.getDeclaredMethod("toDatumInternal", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeSINT32.class.getDeclaredMethod("toDatumArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeSINT32.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

