/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderContHandler;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderDomHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
class OracleWebRowSetXmlReaderImpl
implements OracleWebRowSetXmlReader {
    private static final String JAVA_SAXPARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    private static final String JAVA_DOMPARSER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String ORACLE_JAXP_SAXPARSER_FACTORY = "oracle.xml.jaxp.JXSAXParserFactory";
    private static final String ORACLE_JAXP_DOMPARSER_FACTORY = "oracle.xml.jaxp.JXDocumentBuilderFactory";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String WEBROWSET_SCHEMA = "http://oracle.com/webfolder/technetwork/jsc/xml/ns/jdbc/webrowset.xsd";
    private Document document;
    private String parserStr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    OracleWebRowSetXmlReaderImpl() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$5, null, new Object[0]);
            }
            this.document = null;
            this.parserStr = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readXML(WebRowSet webRowSet, Reader reader) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void reader2;
            void webrowset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$0, this, webRowSet, reader);
            }
            this.parserStr = this.getSystemProperty(JAVA_SAXPARSER_PROPERTY);
            if (this.parserStr != null) {
                this.readXMLSax((OracleWebRowSet)webrowset, (Reader)reader2);
            } else {
                this.parserStr = this.getSystemProperty(JAVA_DOMPARSER_PROPERTY);
                if (this.parserStr != null) {
                    this.readXMLDom((OracleWebRowSet)webrowset, (Reader)reader2);
                } else {
                    SQLException sQLException = new SQLException("No valid JAXP parser property specified");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void readData(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$1, this, rowSetInternal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readXMLSax(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, oracleWebRowSet, reader);
            }
            try {
                void webrowset;
                void reader2;
                InputSource inputsource = new InputSource((Reader)reader2);
                OracleWebRowSetXmlReaderContHandler contentHandler = new OracleWebRowSetXmlReaderContHandler((RowSet)webrowset);
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                saxParserFactory.setNamespaceAware(true);
                saxParserFactory.setValidating(true);
                saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                SAXParser saxParser = saxParserFactory.newSAXParser();
                saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                saxParser.setProperty(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(inputsource);
            }
            catch (SAXParseException saxparseexception) {
                System.out.println("** Parsing error, line " + saxparseexception.getLineNumber() + ", uri " + saxparseexception.getSystemId());
                System.out.println("   " + saxparseexception.getMessage());
                saxparseexception.printStackTrace();
                SQLException sQLException = new SQLException(saxparseexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            catch (SAXNotRecognizedException saxexception) {
                saxexception.printStackTrace();
                SQLException sQLException = new SQLException("readXMLSax: SAXNotRecognizedException: " + saxexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            catch (SAXException saxexception) {
                saxexception.printStackTrace();
                SQLException sQLException = new SQLException("readXMLSax: SAXException: " + saxexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            catch (FactoryConfigurationError error) {
                error.printStackTrace();
                SQLException sQLException = new SQLException("readXMLSax: Parser factory config: " + error.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            catch (ParserConfigurationException exc) {
                exc.printStackTrace();
                SQLException sQLException = new SQLException("readXMLSax: Parser config: " + exc.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                SQLException sQLException = new SQLException("readXMLSax: " + exc.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readXMLDom(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, oracleWebRowSet, reader);
            }
            try {
                void webrowset;
                void reader2;
                InputSource inputsource = new InputSource((Reader)reader2);
                OracleWebRowSetXmlReaderDomHandler domHandler = new OracleWebRowSetXmlReaderDomHandler((RowSet)webrowset);
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setNamespaceAware(true);
                docBuilderFactory.setValidating(true);
                docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                docBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                docBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                this.document = docBuilder.parse(inputsource);
                domHandler.readXMLDocument(this.document);
            }
            catch (SAXException saxexception) {
                saxexception.printStackTrace();
                SQLException sQLException = new SQLException("readXMLDom: SAXException: " + saxexception.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            catch (FactoryConfigurationError error) {
                error.printStackTrace();
                SQLException sQLException = new SQLException("readXMLDom: Parser factory config: " + error.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            catch (ParserConfigurationException exc) {
                exc.printStackTrace();
                SQLException sQLException = new SQLException("readXMLDom: Parser config: " + exc.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                SQLException sQLException = new SQLException("readXMLDom: " + exc.getMessage());
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getSystemProperty(String string) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$4, this, string);
            }
            String str = null;
            try {
                void prop;
                str = System.getProperty((String)prop);
            }
            catch (SecurityException exc) {
                str = null;
            }
            String string2 = str;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$4, this, string2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$4, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleWebRowSetXmlReaderImpl.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = OracleWebRowSetXmlReaderImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("getSystemProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readXMLDom", OracleWebRowSet.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readXMLSax", OracleWebRowSet.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readData", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readXML", WebRowSet.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

